{-------------------------------------------------------------------}
{ BORBTNS - BWCC Style CheckBoxes & Radio Buttons for Delphi v 1.01 }
{-------------------------------------------------------------------}
{ v. 1.00 April, 8 1995                                             }
{ v. 1.01  July, 6 1995  Controls refreshed when caption changes    }
{-------------------------------------------------------------------}
{ Copyright Enrico Lodolo                                           }
{ via F.Bolognese 27/3 - 440129 Bologna - Italy                     }
{ CIS 100275,1255 - Internet ldlc18k1@bo.nettuno.it                 }
{-------------------------------------------------------------------}
{ v. 1.02 July, 5 1997 modified by W. Braun-Boehm                   }
{  all changes marked with WB                                       }
{  add DB support                                                   }
{  eMail Willi_Braun@compuserve.com                                 }
{  Delphi 1,2,3 supported                                           }
{-------------------------------------------------------------------}


unit BorBtns;

interface

uses
  SysUtils, WinTypes, WinProcs,Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus,
  dbconsts,DB,DBCtrls,DbTables; { WB }

type
  TBorCheck = class(TCustomControl)
  private
    FAllowGrayed: Boolean;  { WB }
    FDown:Boolean;
    FState:TCheckBoxState;
    FFocused:Boolean;
    FCheckColor:TColor;
    FReadOnly : boolean;    { WB }
  protected
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
    procedure PaintWCanv( mCanvas :  TControlCanvas;
                          mState : TCheckBoxState) ; { WB }
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;X, Y: Integer);
      override;
    procedure KeyDown(var Key:Word;Shift:TShiftSTate); override;
    procedure KeyUp(var Key:Word;Shift:TShiftSTate); override;
    procedure SetDown(Value:Boolean);
    procedure SetState(Value:TCheckBoxState);
    procedure SetChecked(Value:Boolean);
    function  GetChecked:Boolean;
    procedure SetCheckColor(Value:TColor);
    function  GetCaption: TCaption;
    procedure SetCaption(const Value:TCaption);
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure Toggle; virtual; { WB }
  public
  published
    property AllowGrayed: Boolean read FAllowGrayed
             write FAllowGrayed default False; { WB }
    property Caption:TCaption read GetCaption write SetCaption;
    property CheckColor:TColor read FCheckColor write SetCheckColor
             default clBlack;
    property Checked:Boolean read GetChecked write SetChecked
             default False;
    property Down:Boolean read FDown write SetDown default False;
    property DragCursor;
    property DragMode;
    property Enabled;       { WB }
    property Font;
    property ParentColor;   { WB }
    property ParentFont;
    property ParentShowHint;  { WB }
    property PopupMenu;
    property ReadOnly : boolean read FReadOnly
                        write FReadOnly default False; { WB }
    property ShowHint;
    property State:TCheckBoxState read FState write SetState
             default cbUnchecked;
    property TabOrder;
    property TabStop;
    property Visible;      { WB }
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;       { WB }
    property OnExit;        { WB }
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
{$IFDEF WIN32}
    property OnStartDrag;   { WB }
{$ENDIF}
  end;

  { this class is from WB }
  TDBBorCheck = class(TBorCheck)
  private
    FDataLink: TFieldDataLink;
    FValueCheck: string;
    FValueUncheck: string;
{$IFDEF WIN32}
    FCanvas: TControlCanvas;
    function GetField: TField;
    procedure CMGetDataLink(var Message: TMessage); message CM_GETDATALINK;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
{$ENDIF}
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetFieldState: TCheckBoxState;
    function GetReadOnly: Boolean;
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure SetReadOnly(Value: Boolean);
    procedure SetValueCheck(const Value: string);
    procedure SetValueUncheck(const Value: string);
    procedure UpdateData(Sender: TObject);
    function ValueMatch(const ValueList, Value: string): Boolean;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure Toggle; override;
  protected
    procedure KeyPress(var Key: Char); override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Checked;
{$IFDEF WIN32}
    property Field: TField read GetField;
{$ENDIF}
    property State;
  published
    property Caption;
    property Color;
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property ValueChecked: string read FValueCheck write SetValueCheck;
    property ValueUnchecked: string read FValueUncheck write SetValueUncheck;
    property Visible;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
{$IFDEF WIN32}
    property OnStartDrag;
{$ENDIF}
  end;


  TBorRadio = class(TCustomControl)
  private
    FDown:Boolean;
    FChecked:Boolean;
    FFocused:Boolean;
    FCheckColor:TColor;
    FGroupIndex:Byte;
    FReadOnly : boolean;
    procedure TurnSiblingsOff;
  protected
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;X, Y: Integer);
      override;
    procedure KeyDown(var Key:Word;Shift:TShiftSTate); override;
    procedure KeyUp(var Key:Word;Shift:TShiftSTate); override;
    function  GetCaption: TCaption;
    procedure SetCaption(const Value:TCaption);
    procedure SetDown(Value:Boolean);
    procedure SetChecked(Value:Boolean);
    procedure SetCheckColor(Value:TColor);
    procedure DoEnter; override;
    procedure DoExit; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Toggle;
    property Down:Boolean read FDown write SetDown default False;
  published
    property Caption : TCaption read GetCaption write SetCaption;
    property CheckColor:TColor read FCheckColor write SetCheckColor default clBlack;
    property Checked:Boolean read FChecked write SetChecked default False;
    property Color;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property GroupIndex:Byte read FGroupIndex write FGroupIndex default 0;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly: Boolean read FReadOnly write FReadOnly default False;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
{$IFDEF WIN32}
    property OnStartDrag; { WB }
{$ENDIF}
  end;

procedure Register;

implementation

{-------------------------------------------------------------------}
{                          Borland Style CheckBox                   }
{-------------------------------------------------------------------}

constructor TBorCheck.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FReadOnly:=False;    { WB }
  Width := 97;
  Height := 17;
  ParentColor:=False;
  Color:=clBtnFace;
end;

const BW=12;


procedure TBorCheck.Paint;
begin
   PaintWCanv(TControlCanvas(Canvas),State);  { WB }
end;

{ procedure from WB }
procedure TBorCheck.PaintWCanv( mCanvas :  TControlCanvas; mState : TCheckBoxState);
var BL,BT,BR,BB:Integer;
    TX,TY,TW,TH:Integer;
    Rect:TRect;
begin
{ Paint is original from Enrico Lodolo }
     mCanvas.Font:=Font;
     with mCanvas do
       begin
         BT:=(Height div 2)-(BW div 2);
         BB:=BT+BW;
         BL:=1;
         BR:=BW+1;
         Brush.Color:=clBtnFace;

         if not FDown then
           begin
             Pen.Color:=clBtnFace;
             Rectangle(BL,BT,BR,BB);
             Pen.Color:=clBtnHighLight;
             MoveTo(BL,BB);
             LineTo(BL,BT);
             LineTo(BR,BT);
             Pen.Color:=clBtnShadow;
             LineTo(BR,BB);
             LineTo(BL,BB);
           end
         else
           begin
             Pen.Color:=clBlack;
             Pen.Width:=2;
             Rectangle(BL+1,BT+1,BR+1,BB+1);
             Pen.Width:=1;
           end;

         case mState of
           cbChecked:begin
                       Pen.Color:=FCheckColor;
                       Pen.Width:=1;
                       Dec(BT);Dec(BB);
                       MoveTo(BL+2,BT+BW div 2+1);
                       LineTo(BL+2,BB-1);
                       MoveTo(BL+3,BT+BW div 2);
                       LineTo(BL+3,BB-2);
                       MoveTo(BL+2,BB-1);
                       LineTo(BR-2,BT+3);
                       MoveTo(BL+3,BB-1);
                       LineTo(BR-1,BT+3);
                     end;
            cbGrayed:begin
                       if Down then
                         begin
                           Pen.Color:=clBtnFace;
                           Brush.Color:=clBtnFace;
                           Rectangle(BL+2,BT+2,BR-1,BB-1);
                         end;
                       Brush.Color:=clBtnShadow;
                       Rectangle(BL+2,BT+2,BR-1,BB-1);
                     end;
         end;
         Brush.Color:=Color;   { WB }
         TX:=BR+5;
         TY:=(Height div 2)-(TextHeight(Caption)) div 2 -1; { WB }
         TW:=TextWidth(Caption);
         TH:=TextHeight(Caption);
         TextOut(TX,TY,Caption);
         Rect:=Bounds(TX-1,0,TW+3,Height);
         FrameRect(Rect);

         if FFocused then
         begin
           Brush.Color:=clBtnFace;
           DrawFocusRect(Rect);
         end;
      end;
end;

function TBorCheck.GetCaption:TCaption;
{ original
var Len:Integer;

begin
     Len := GetTextBuf(@Result, 256);
     Move(Result[0], Result[1], Len);
     Result[0] := Char(Len);
end;}
begin
   Result:=Text; { WB }
end;

procedure TBorCheck.SetCaption(const Value:TCaption);
{ original
var Buffer: array[0..255] of Char;

begin
     if GetCaption <> Value then
       SetTextBuf(StrPCopy(Buffer,Value));
     Invalidate;
end;
}

{ WB }
begin
   if Text=Value then exit;
   Text:=Value;
   Invalidate;
end;

procedure TBorCheck.SetDown(Value:Boolean);
begin
   if FDown=Value then exit;
   FDown:=Value;
   Paint;
end;

{ procedure from WB }
procedure TBorCheck.Toggle;
begin
   case State of
    cbUnchecked:
      if AllowGrayed then State := cbGrayed else State := cbChecked;
    cbChecked: State := cbUnchecked;
    cbGrayed: State := cbChecked;
  end;
end;

procedure TBorCheck.SetState(Value:TCheckBoxState);
begin
   if FState=Value then exit;
   FState:=Value;
   Paint;
   Click;
end;

function TBorCheck.GetChecked: Boolean;
begin
   Result:=State=cbChecked;
end;

procedure TBorCheck.SetChecked(Value:Boolean);
begin
   if Value then State := cbChecked
            else State := cbUnchecked;
end;

procedure TBorCheck.SetCheckColor(Value:TColor);
begin
   if FCheckColor=Value then exit;    { WB }
   FCheckColor:=Value;
   Paint;
end;

procedure TBorCheck.DoEnter;
begin
   inherited DoEnter;
   FFocused:=True;
   Paint;
end;

procedure TBorCheck.DoExit;
begin
   inherited DoExit;
   FFocused:=False;
   Paint;
end;

procedure TBorCheck.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   SetFocus;
   FFocused:=True;
   inherited MouseDown(Button, Shift, X, Y);
   MouseCapture:=True;
   { Down:=True }
   Down:=Button=mbLeft; { WB }
end;

procedure TBorCheck.MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer);
begin
   MouseCapture:=False;
   Down:=False;
{  if (X>=0) and (X<=Width) and (Y>=0) and (Y<=Height) then
       Checked:=not Checked; }

   { WB }
   if (Button=mbLeft) and (X>=0) and (X<=Width) and (Y>=0) and (Y<=Height)
       and not FReadOnly then
      Toggle;
   inherited MouseUp(Button, Shift, X, Y);
end;

procedure TBorCheck.MouseMove(Shift: TShiftState;X, Y: Integer);
begin
   if MouseCapture then
      Down:=(X>=0) and (X<=Width) and (Y>=0) and (Y<=Height);
   inherited MouseMove(Shift,X,Y);
end;

procedure TBorCheck.KeyDown(var Key:Word;Shift:TShiftSTate);
begin
   if Key=vk_Space then Down:=True;
   inherited KeyDown(Key,Shift);
end;

procedure TBorCheck.KeyUp(var Key:Word;Shift:TShiftSTate);
begin
   if Key=vk_Space then
   begin
      Down:=False;
{      Checked:=not Checked; }
      if not FReadOnly then Toggle; { WB }
   end;
end;

{ TDBBorCheck }
{ this class from WB
{ modified TBorCheck and TDBCheckBox   }

constructor TDBBorCheck.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
{$IFDEF WIN32}
  ControlStyle := ControlStyle + [csReplicatable];
{$ENDIF}
  State := cbUnchecked;
  FValueCheck := STextTrue;
  FValueUncheck := STextFalse;
  { For delphi < 3
    FValueCheck := LoadStr(STextTrue);
    FValueUncheck := LoadStr(STextFalse);  }
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
end;

destructor TDBBorCheck.Destroy;
begin
{$IFDEF WIN32}
   FCanvas.Free;
{$ENDIF}
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

procedure TDBBorCheck.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

function TDBBorCheck.GetFieldState: TCheckBoxState;
var
  Text: string;
begin
  if FDatalink.Field <> nil then
    if FDataLink.Field.IsNull then
      Result := cbGrayed
    else if FDataLink.Field.DataType = ftBoolean then
      if FDataLink.Field.AsBoolean then
        Result := cbChecked
      else
        Result := cbUnchecked
    else
    begin
      Result := cbGrayed;
      Text := FDataLink.Field.Text;
      if ValueMatch(FValueCheck, Text) then Result := cbChecked else
        if ValueMatch(FValueUncheck, Text) then Result := cbUnchecked;
    end
  else
    Result := cbUnchecked;
end;


procedure TDBBorCheck.DataChange(Sender: TObject);
begin
  State := GetFieldState;
end;

procedure TDBBorCheck.UpdateData(Sender: TObject);
var
  Pos: Integer;
  S: string;
begin
  if State = cbGrayed then
    FDataLink.Field.Clear
  else
    if FDataLink.Field.DataType = ftBoolean then
      FDataLink.Field.AsBoolean := Checked
    else
    begin
      if Checked then S := FValueCheck else S := FValueUncheck;
      Pos := 1;
      FDataLink.Field.Text := ExtractFieldName(S, Pos);
    end;
end;

function TDBBorCheck.ValueMatch(const ValueList, Value: string): Boolean;
var
  Pos: Integer;
begin
  Result := False;
  Pos := 1;
  while Pos <= Length(ValueList) do
    if AnsiCompareText(ExtractFieldName(ValueList, Pos), Value) = 0 then
    begin
      Result := True;
      Break;
    end;
end;

procedure TDBBorCheck.Toggle;
begin
  if not ReadOnly and FDataLink.Edit then
  begin
    inherited Toggle;
    FDataLink.Modified;
  end;
end;

function TDBBorCheck.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TDBBorCheck.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
{$IFDEF WIN32}
  if Value <> nil then Value.FreeNotification(Self);
{$ENDIF}
end;

function TDBBorCheck.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;

procedure TDBBorCheck.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;

function TDBBorCheck.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;

procedure TDBBorCheck.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;

{$IFDEF WIN32}
{ for dbctrlGrid}
function TDBBorCheck.GetField: TField;
begin
  Result := FDataLink.Field;
end;

procedure TDBBorCheck.CMGetDataLink(var Message: TMessage);
begin
  Message.Result := Integer(FDataLink);
end;

procedure TDBBorCheck.WMPaint(var Message: TWMPaint);
var DC: HDC;
    PS: TPaintStruct;
begin
  if not (csPaintCopy in ControlState) then
  begin
     inherited;
     exit;
  end;
  if FCanvas = nil then
  begin
    FCanvas := TControlCanvas.Create;
    FCanvas.Control := Self;
  end;
  DC := Message.DC;
  if DC = 0 then DC := BeginPaint(Handle, PS);
  FCanvas.Handle := DC;
  try
     PaintWCanv(FCanvas,GetFieldState);
  finally
     FCanvas.Handle := 0;
     if Message.DC = 0 then EndPaint(Handle, PS);
  end;
end;

{$ENDIF}

procedure TDBBorCheck.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    #8, ' ': FDataLink.Edit;
    #27:     FDataLink.Reset;
  end;
end;

procedure TDBBorCheck.SetValueCheck(const Value: string);
begin
  FValueCheck := Value;
  DataChange(Self);
end;

procedure TDBBorCheck.SetValueUncheck(const Value: string);
begin
  FValueUncheck := Value;
  DataChange(Self);
end;


procedure TDBBorCheck.CMExit(var Message: TCMExit);
begin
  try
    FDataLink.UpdateRecord;
  except
    SetFocus;
    raise;
  end;
  inherited;
end;



{-------------------------------------------------------------------}
{                           Borland Radio Button                    }
{-------------------------------------------------------------------}

constructor TBorRadio.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 98;
  Height := 20;
  ParentColor:=False;
  Color:=clBtnFace;
  FReadOnly:=False;
end;

procedure TBorRadio.Paint;
var BL,BT,BR,BB,BM:Integer;
    TX,TY,TW,TH:Integer;
    CX,CY:Integer;
    Rect:TRect;
begin
     Canvas.Font:=Font;
     with Canvas do
       begin
         BM:=BW div 2;
         BT:=(Height div 2)-BM;
         BB:=BT+BW;
         BL:=1;
         BR:=BW+1;
         Brush.Color:=clBtnFace;
         if Down then
           begin
             Pen.Color:=clBlack;
             MoveTo(BL+BM,BT);
             LineTo(BL,BT+BM);
             LineTo(BL+BM,BB);
             LineTo(BR,BT+BM);
             LineTo(BL+BM,BT);
             MoveTo(BL+BM,BT+1);
             LineTo(BL+1,BT+BM);
             LineTo(BL+BM,BB-1);
             LineTo(BR-1,BT+BM);
             LineTo(BL+BM,BT+1);
           end
         else
           begin
             Pen.Color:=clBtnFace;
             Rectangle(BL,BT,BR,BB);
             if Checked then Pen.Color:=clBtnShadow
                        else Pen.Color:=clBtnHighLight;
             MoveTo(BL+BM,BT);
             LineTo(BL,BT+BM);
             LineTo(BL+BM,BB);
             if Checked then Pen.Color:=clBtnHighLight
                        else Pen.Color:=clBtnShadow;
             LineTo(BR,BT+BM);
             LineTo(BL+BM,BT);
           end;
         if Checked then
            begin
              Pen.Color:=CheckColor;
              CX:=BL+BM;CY:=BT+BM;
              MoveTo(CX-1,CY-1);
              LineTo(CX+2,CY-1);
              MoveTo(CX-2,CY);
              LineTo(CX+3,CY);
              MoveTo(CX-1,CY+1);
              LineTo(CX+2,CY+1);
              MoveTo(CX,CY-2);
              LineTo(CX,CY+3);
            end;
         TX:=BR+5;
         TY:=(Height div 2)+(Font.Height div 2)-1;
         TW:=TextWidth(Caption);
         TH:=TextHeight(Caption);
         TextOut(TX,TY,Caption);
         Brush.Color:=Color;
         Rect:=Bounds(TX-1,TY,TW+3,TH+1);
         FrameRect(Rect);
         if FFocused then
           DrawFocusRect(Rect);
       end;
end;

function TBorRadio.GetCaption:TCaption;
begin
   Result:=Text;
end;

procedure TBorRadio.SetCaption(const Value:TCaption);
begin
   if Text=Value then exit;
   Text:=Value;
   Invalidate;
end;

procedure TBorRadio.Toggle;
begin
   if not FReadOnly then
      Checked:=not Checked;
end;

procedure TBorRadio.SetDown(Value:Boolean);
begin
   if FDown=Value then exit;
   FDown:=Value;
   Paint;
end;

procedure TBorRadio.TurnSiblingsOff;
var i:Integer;
    Sibling: TBorRadio;
begin
   if Parent <> nil then
      for i:=0 to Parent.ControlCount-1 do
         if Parent.Controls[i] is TBorRadio then
         begin
            Sibling:=TBorRadio(Parent.Controls[i]);
            if (Sibling<>Self) and
               (Sibling.GroupIndex=GroupIndex) then
               Sibling.SetChecked(False);
         end;
end;

procedure TBorRadio.SetChecked(Value: Boolean);
begin
   if FChecked=Value then exit;
   begin
      TabStop:=Value;
      FChecked:=Value;
      if Value then
      begin
        TurnSiblingsOff;
        Click;
      end;
      Paint;
   end;
end;

procedure TBorRadio.SetCheckColor(Value:TColor);
begin
   FCheckColor:=Value;
   Paint;
end;

procedure TBorRadio.DoEnter;
begin
   inherited DoEnter;
   FFocused:=True;
   Checked:=True;
   Paint;
end;

procedure TBorRadio.DoExit;
begin
   inherited DoExit;
   FFocused:=False;
   Paint;
end;

procedure TBorRadio.MouseDown(Button: TMouseButton; Shift: TShiftState;X, Y: Integer);
begin
   SetFocus;
   FFocused:=True;
   inherited MouseDown(Button, Shift, X, Y);
   MouseCapture:=True;
   Down:=True;
end;

procedure TBorRadio.MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer);
begin
   MouseCapture:=False;
   Down:=False;
   if (X>=0) and (X<=Width) and (Y>=0) and (Y<=Height) and not FReadonly
     and not Checked then Checked:=True;
   inherited MouseUp(Button, Shift, X, Y);
end;

procedure TBorRadio.MouseMove(Shift: TShiftState;X, Y: Integer);
begin
   if MouseCapture then
      Down:=(X>=0) and (X<=Width) and (Y>=0) and (Y<=Height);
   inherited MouseMove(Shift,X,Y);
end;

procedure TBorRadio.KeyDown(var Key:Word;Shift:TShiftSTate);
begin
   if Key=vk_Space then Down:=True;
   inherited KeyDown(Key,Shift);
end;

procedure TBorRadio.KeyUp(var Key:Word;Shift:TShiftSTate);
begin
   if Key=vk_Space then
   begin
      Down:=False;
      if not FReadOnly and not Checked then Checked:=True;
   end;
end;

procedure Register;

begin
     RegisterComponents('Extra',[TBorCheck,TDBBorCheck,TBorRadio]);
end;

end.
